﻿function JImage(owner, parent, name, dataset, field, rect, flags, tab)
{
	var self = this,
		_disposed = false,
		_loadCnt = 0;

	this.initialize (owner, parent, name, null, null, rect, flags, field, dataset, tab);

	this.methods  = (cmRender | cmLoad);
	this.src      = null;
	this.msgNoImage = this.owner.localize("msgNoImage");

	if (this.msgNoImage == null)
		this.msgNoImage = "Položka nemá obrázek.";
	this.ignoreError = true;

	this.refreshImage = refreshImage;
	this.render		= render;
	this.load		= load;
	this.loaded		= loaded;
	this.dispose	= dispose;
//	this.doubleClick = doubleClick;
//	this.error       = error;

	function render(fs)
	{
		if (self.isInvisible())
			return;

		var addClass = '';
/*
		if (self.isInvisible())
		{
			addClass += ' invisible';
		}*/
//																									MB 10.1.2014 - scrollbar je občas potřeba
		fs.append('<div class="imageBox'+ addClass +'" id="' + self.name + '_box" style="' + self.rect + '">');/* + '; overflow:hidden">*/
		fs.append('<img class="image'+ addClass +'" id="' + self.name + '" name="' + self.name + '" src="" alt="' + self.dataset.fields[self.field].caption + ' (' + self.owner.localize('capDblClickImg') + ')" />');
		fs.append('</div>');
		fs.append('<span id="' + self.name + '_upload" name="' + self.name + '_upload" style="display:none;font-family:MS Sans Serif; position:absolute; top:' + (self.rect.top + 8) + '; left:' + self.rect.left + '">&nbsp;' + self.msgNoImage);
		fs.append('<br/>&nbsp;<input id="' + self.name + '_uploadButton" type="button" value="' + self.owner.localize('msgUpload') + '" /></span>');
	}

	function load()
	{
		if (self.isInvisible())
			return;

		_loadCnt++;
		if (_loadCnt == 1)
		{
			var elem = self.$$();
			elem.ondblclick = doubleClick;
			//	  elem.onerror = error;
			elem.onload = loaded;

			self.$$('_uploadButton').onclick = doubleClick;
		}

		var name = self.dataset.get(self.field);
		if (utils.isEmpty(name))
		{
			self.ignoreError = false;
			error();
			return;
		}

		self.ignoreError = true;
		var query = new Postback(raGetBlob);
		query.set("act", "gblob");
		query.set("cid", self.owner.session);
		query.set("afm", self.owner.activeForm.name);
		query.set("obj", self.dataset.name);
		query.set("res", self.dataset.get(self.field));
		query.set("flg", self.flags);
		query.set("imw", self.rect.width);
		query.set("imh", self.rect.height);

		if (self.$(self.name) != null)
		{
			self.src = query.toString();
			self.ignoreError = false;

			if (self.owner.isPortalVersion())
				self.$$().src = self.owner.cgiPath() + '&' + self.src;
			else
				self.$$().src = self.owner.cgiPath() + '?' + self.src;

		}
	}

	function loaded()
	{
		var image = self.$$();

		if (image.offsetHeight > image.offsetWidth)
		{
			image.style.width = "auto";
			if (image.height > self.rect.height)
			image.style.height = self.rect.height;
		}
		else
		{
			if (image.width > self.rect.width)
			image.style.width = self.rect.width;
			image.style.height = "auto";
		}

	}

	function doubleClick()
	{
		if (self.owner.isPortalVersion())
			return;

		var query = new Postback(raEditBlob);
		query.set("act", "eblob");
		query.set("newAct", "sblob");
		query.set("cid", self.owner.session);
		query.set("afm", self.owner.activeForm.name);
		query.set("obj", self.dataset.name);
		query.set("rec", self.dataset.getCurrentRecord().key);
		query.set("fid", self.field);

		self.owner.lastImg = self;
		img_win = window.open(self.owner.cgiPath() + '?' + query.toString(), "", "width=370,height=100,location=no,menubar=no,resizable=no,scrollbars=no,status=yes");
	}
	
	function error()
	{
		if (self.ignoreError)
			return;

		self.$$().style.display = "none";
		self.$$("_upload").style.display = "";

		if (self.dataset.isReadOnly(self.field))
		{
			alert('you don\'t have permissions for this operation.');
			self.$$("_uploadButton").enabled = false;
		}
	}

	function dispose()
	{
		if (_disposed)
			return;

		var elem = self.$$();
		elem.ondblclick = null;
		elem.onerror = null;
		elem.onload = null;

		self.$(self.name + '_uploadButton').onclick = null;

		self.base.dispose.call(self);
		_disposed = true;
	}

	function refreshImage(newName)
	{
		if (self.isInvisible())
			return;

		self.$$("_upload").style.display = "none";
		self.$$().style.display = "";
		var record = self.dataset.getCurrentRecord();
		var status = record.getState();
		self.dataset.set(self.field, newName);
		record.setState(status); // let's keep original status - image is already written, no change submit is required
		self.load();
	}
}

JImage.inheritsFrom(ControlBase);


function refreshImage(newName)
{
  if (window.ICApp.lastImg != null)
    window.ICApp.lastImg.refreshImage(newName);
}

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();
